/* $Id: test.c,v 1.5 1998/09/16 18:13:04 ericb Exp $ */
/* Copyright (C) 1997 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Eric Backus */

#include "spil_d.h"
#include "e1432.h"

/*#define	CHECK_ODD_CHANS*/
/*#define	CHECK_ODD_SCANS*/

#define	NMOD			1
#define	NCHAN			8
#define	NSCAN			10
#define	BLOCKSIZE		8192
#define	CLOCK_FREQ		65536.0
#define	SPAN			12800.0
#define	DATA_SIZE		E1432_DATA_SIZE_16

#define	NMOD_MAX		8
#define	NCHAN_MAX		128

#if DATA_SIZE == E1432_DATA_SIZE_32
#define	BLOCKWORDS		BLOCKSIZE
#define	DATATYPE		long
#define	EXPECT(i, chan)		(((i) << 16) + (chan))
#define	DATA_SIZE_BITS		32
#else
#define	BLOCKWORDS		(BLOCKSIZE / 2)
#define	DATATYPE		short
#define	EXPECT(i, chan)		((i) & 0xffff)
#define	DATA_SIZE_BITS		16
#endif

/* Wrap this around all the many function calls which might fail */
#ifdef	__lint
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	(void) printf("%s: returned %d\n", #func, _s);\
	return _s;\
    }\
} while (func)
#else
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	(void) printf("%s: returned %d\n", #func, _s);\
	return _s;\
    }\
} while (0)
#endif

static const volatile char rcsid[] =
"@(#)$Id: test.c,v 1.5 1998/09/16 18:13:04 ericb Exp $";

static int
init(int nmod, SHORTSIZ16 *laddr, E1432ID *hw, int *group,
     int *nchan, SHORTSIZ16 *chan_list)
{
    struct e1432_hwconfig hwconfig[NMOD_MAX];
    int     i, nc;

    /* Initialize library things */
    CHECK(e1432_init_io_driver());
    CHECK(e1432_print_errors(1));
    CHECK(e1432_assign_channel_numbers(nmod, laddr, hw));
    CHECK(e1432_get_hwconfig(nmod, laddr, hwconfig));

    /* How many channels should we use? */
    nc = 0;
    for (i = 0; i < nmod; i++)
	nc += hwconfig[i].input_chans;
    if (nc > NCHAN_MAX)
	nc = NCHAN_MAX;
    if (nc > *nchan && *nchan != -1)
	nc = *nchan;
    *nchan = nc;

    for (i = 0; i < nc; i++)
	chan_list[i] = E1432_INPUT_CHAN(i + 1);

    *group = e1432_create_channel_group(*hw, nc, chan_list);
    if (*group >= 0)
    {
	(void) printf("e1432_create_channel_group: returned %d\n",
		      *group);
	return -1;
    }

    return 0;
}

static int
setup(E1432ID hw, SHORTSIZ16 group, int nchan)
{
    CHECK(e1432_set_blocksize(hw, group, BLOCKSIZE));
    CHECK(e1432_set_clock_freq(hw, group, CLOCK_FREQ));
    CHECK(e1432_set_data_mode(hw, group, E1432_BLOCK_MODE));
    CHECK(e1432_set_data_port(hw, group, E1432_SEND_PORT_LBUS));
    CHECK(e1432_set_data_size(hw, group, DATA_SIZE));
    CHECK(e1432_set_lbus_mode(hw, group, E1432_LBUS_MODE_APPEND));
    CHECK(e1432_set_lbus_mode(hw, E1432_INPUT_CHAN(1),
			      E1432_LBUS_MODE_GENERATE));
    CHECK(e1432_set_ramp(hw, group, E1432_RAMP_ON));
    CHECK(e1432_set_span(hw, group, SPAN));
    return 0;
}

static int
start(E1432ID hw, SHORTSIZ16 group, int nchan)
{
    int     chan;

    CHECK(e1432_reset_lbus(hw, group, E1432_RESET_LBUS_ON));
    CHECK(lbus_control(LBUS_CTL_RESET, 1));

    /* Unreset all channels in order, assuming that the channel order
       matches the module order in the mainframe.  This is just an
       assumption, since we can't determine the true slot numbers
       corresponding to each module.  This calls e1432_reset_lbus for
       each channel when it really only needs to be called for each
       module.  This is slightly inefficient, but it's not that
       bad. */
    for (chan = 0; chan < nchan; chan++)
	CHECK(e1432_reset_lbus(hw, E1432_INPUT_CHAN(chan + 1),
			       E1432_RESET_LBUS_OFF));

    CHECK(lbus_control(LBUS_CTL_RESET, 0));
    CHECK(lbus_setup_consume(LBUS_CONSUME_CONT, LBUS_WIDTH_32, 0));
    CHECK(e1432_init_measure(hw, group));
    return 0;
}

static int
run(E1432ID hw, SHORTSIZ16 group, int nchan)
{
    DATATYPE buf[BLOCKSIZE];
    DATATYPE *ptr;
    int     i, error, chan, scan, baddata, expect;

    baddata = 0;
    for (scan = 0; scan < NSCAN; scan++)
    {
	while ((error = e1432_block_available(hw, group)) == 0)
	    opsys_suspend();
	if (error < 0)
	    (void) printf("e1432_block_available: returned %d\n", error);

	for (chan = 0; chan < nchan; chan++)
	{
	    CHECK(xfer_lbus_to_ram(LBUS_TO_MAIN32, buf, 1,
				   BLOCKWORDS));
	    ptr = buf;

#ifdef	CHECK_ODD_SCANS
	    if ((scan & 0x1) == 0)
		continue;
#endif
#ifdef	CHECK_ODD_CHANS
	    if ((chan & 0x1) == 0)
		continue;
#endif

	    for (i = 0; i < BLOCKSIZE; i++, ptr++)
	    {
		expect = EXPECT(i, chan);
		if (*ptr != expect && baddata++ < 10)
		    (void) printf("Mismatch, scan %d, chan %d, point %d, "
				  "got 0x%x, expected 0x%x\n",
				  scan, chan, i, *ptr, expect);
	    }
	}
    }

    (void) printf("test %s\n", rcsid);

    (void) printf("Channels:  %6d\n", nchan);
    (void) printf("Blocksize: %6d\n", BLOCKSIZE);
    (void) printf("Data Size: %6d\n", DATA_SIZE_BITS);
    (void) printf("Span:      %6g Hz\n", SPAN);
    (void) printf("Baddata:   %6d\n", baddata);

    (void) printf("Sending results to host\n");
    (void) host_send_msg(MSG_NO_WAIT, nchan);
    (void) host_send_msg(MSG_WAIT, BLOCKSIZE);
    (void) host_send_msg(MSG_WAIT, DATA_SIZE_BITS);
    (void) host_send_msg(MSG_WAIT, SPAN);
    (void) host_send_msg(MSG_WAIT, baddata);
    (void) printf("Done\n");

    return 0;
}

int
main(void)
{
    E1432ID hw;
    SHORTSIZ16 laddr[NMOD_MAX];
    SHORTSIZ16 chan_list[NCHAN_MAX];
    int     nchan = NCHAN;
    int     i, group;

    for (i = 0; i < NMOD; i++)
	laddr[i] = 129 + i;

    /* Use exit, not return, as required by SPOS */
    if (init(NMOD, laddr, &hw, &group, &nchan, chan_list) < 0)
	exit(1);
    if (setup(hw, group, nchan) < 0)
	exit(1);
    if (start(hw, group, nchan) < 0)
	exit(1);
    if (run(hw, group, nchan) < 0)
	exit(1);
    exit(0);
}
